#include<cstdio>
#include<cstring>
#include<algorithm>
#include<iostream>
#include<cmath>
#include<set>
#include<vector>
#include<random>
#include<ctime>
using namespace std;
const int N = 4941; // number of demands
const double facility_cost = 20; 
const int dim = 3; //dimension 
double cost = 0; // total cost 
vector<int> Fset; // the set of open facility
struct demand {
	int t;
	double x[dim + 1];
	double r;
}D[N + 1];
double g[N + 5][N + 5]; // g[i][j] represents the distance between i-th point and j-th point
default_random_engine e;
uniform_real_distribution<double> u(0,1); // generate uniform real number from [0,1]
int order[N + 5]; // order[i] represents the point's number arriving in i-th time

inline double dist(demand &d1, demand &d2) {
	double ret = 0;
	for (int i = 1; i <= dim; i++)
		ret += (d1.x[i] - d2.x[i]) * (d1.x[i] - d2.x[i]);
	return sqrt(ret);
}

int main() {
	freopen("USpowerGrid.txt", "r", stdin);
	for (int i = 1; i <= N; i++) 
		for (int j = i + 1; j <= N; j++) {
			int a, b, c;
			scanf("%d%d%d", &a, &b, &c);
			g[a][b] = g[b][a] = c;
		}
	freopen("USpowerGrid15_order.txt", "r", stdin);
	for (int i = 1; i <= N; i++)
		scanf("%d", &order[i]);
	for (int cnt = 1; cnt <= 10; cnt++) {
		e.seed(time(0));
		Fset.clear();
		for (int i = 1; i <= N; i++) {
			int x = order[i];
			int siz = Fset.size();
			double connect_cost = 1e9;
			for (int j = 0; j < siz; j++) {
				int pos = Fset[j];
				connect_cost = min(connect_cost, g[x][pos]);
			}
			if (connect_cost > facility_cost) {
				Fset.push_back(x);
				continue;
			}
			double r = u(e);
			if (facility_cost * r <= connect_cost) 
				Fset.push_back(x);
			else 
				cost += connect_cost;
		}
		cost += (Fset.size() * facility_cost);
	}
	printf("%lf\n", cost / 10);
	printf("%lu\n", Fset.size());
}